<?php
// 不要问为什么不用数据库类型的  php的不行吗 简单方便
require_once __DIR__.'/config.php';
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $site_config['site_title']; ?> - 让网络访问更轻松便捷</title>
    <link rel="icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>🌬️</text></svg>">
    <style>
        :root {
            --primary-color: #5CACEE;
            --primary-light: #87CEEB;
            --primary-dark: #2a4e9a;
            --secondary-color: #ff7eb3;
            --accent-color: #5F27CD;
            --success-color: #10AC84;
            --warning-color: #FF9F43;
            --danger-color: #FF6B6B;
            --text-dark: #2a4e9a;
            --text-medium: #5a6b9c;
            --text-light: #7c8db0;
            --bg-gradient-start: #f0f5ff;
            --bg-gradient-end: #e4ecff;
            --card-bg: rgba(255, 255, 255, 0.98);
            --box-shadow: 0 8px 25px rgba(70, 110, 180, 0.12);
            --hover-shadow: 0 12px 25px rgba(70, 130, 225, 0.2);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', 'Microsoft YaHei', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, var(--bg-gradient-start), var(--bg-gradient-end));
            color: #333;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            position: relative;
            overflow-x: hidden;
            line-height: 1.5;
            padding: 15px;
        }
        
        <?php if ($site_config['background_type'] !== 'none'): ?>
        /* 动态背景样式 */
        body {
            background: linear-gradient(135deg, 
                <?php echo $site_config['background_color1']; ?>, 
                <?php echo $site_config['background_color2']; ?>) !important;
            background-attachment: fixed;
        }
        .wave-bg { display: none; }
        <?php endif; ?>

        /* 波浪背景 */
        .wave-bg {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 60px;
            background: url('data:image/svg+xml;utf8,<svg viewBox="0 0 1200 120" xmlns="http://www.w3.org/2000/svg"><path d="M0 0v46.29c47.79 22.2 103.59 32.17 158 28 70.36-5.37 136.33-33.31 206.8-37.5 73.84-4.36 147.54 16.88 218.2 35.26 69.27 18 138.3 24.88 209.4 13.08 36.15-6 69.85-17.84 104.45-29.34C989.49 25 1113-14.29 1200 52.47V0z" fill="rgba(92, 172, 238, 0.1)"/></svg>');
            background-repeat: no-repeat;
            background-size: cover;
            background-position: bottom;
            z-index: -1;
        }
        
        /* 加载动画 */
        .loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: white;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.4s, visibility 0.4s;
        }
        
        .loader-content {
            text-align: center;
            transform: translateY(-30px);
        }
        
        .loader-animation {
            position: relative;
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
        }
        
        .loader-circle {
            position: absolute;
            width: 100%;
            height: 100%;
            border-radius: 50%;
            border: 4px solid transparent;
            border-top-color: var(--primary-color);
            animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
        }
        
        .loader-circle:nth-child(1) {
            animation-delay: -0.45s;
        }
        
        .loader-circle:nth-child(2) {
            animation-delay: -0.3s;
        }
        
        .loader-circle:nth-child(3) {
            animation-delay: -0.15s;
        }
        
        .loader-text {
            font-size: 16px;
            color: var(--text-medium);
            letter-spacing: 1px;
            font-weight: 500;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .hidden {
            opacity: 0;
            visibility: hidden;
        }
        
        /* 容器样式 */
        .container {
            max-width: 1200px;
            width: 100%;
            margin: 15px auto;
            background: var(--card-bg);
            border-radius: 18px;
            box-shadow: var(--box-shadow);
            padding: 20px;
            position: relative;
            overflow: hidden;
            opacity: 0;
            transform: translateY(10px);
            transition: opacity 0.5s, transform 0.5s;
            border: 1px solid rgba(230, 240, 255, 0.8);
            backdrop-filter: blur(4px);
        }
        
        /* 背景装饰 */
        .bg-element {
            position: absolute;
            border-radius: 50%;
            opacity: 0.08;
            z-index: -1;
            filter: blur(8px);
        }
        
        .bg-1 {
            width: 180px;
            height: 180px;
            background: linear-gradient(135deg, var(--primary-color), var(--accent-color));
            top: -50px;
            right: -50px;
        }
        
        .bg-2 {
            width: 140px;
            height: 140px;
            background: linear-gradient(135deg, var(--primary-light), var(--success-color));
            bottom: -40px;
            left: -30px;
        }
        
        .bg-3 {
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, var(--danger-color), var(--warning-color));
            bottom: 80px;
            right: 70px;
        }
        
        /* 顶部区域 */
        header {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 0 0 20px;
            margin-bottom: 15px;
            position: relative;
        }
        
        .avatar-container {
            position: relative;
            width: 96px;
            height: 96px;
            margin-bottom: 16px;
            margin-top: 5px;
        }
        
        .avatar {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            overflow: hidden;
            border: 3px solid rgba(255, 255, 255, 0.95);
            box-shadow: 0 6px 16px rgba(40, 90, 150, 0.15);
            background: #f0f7ff;
            position: relative;
            z-index: 2;
            transition: transform 0.4s ease;
        }
        
        .avatar:hover {
            transform: scale(1.05);
        }
        
        .avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }
        
        .avatar-bg {
            position: absolute;
            top: -10px;
            left: -10px;
            width: 116px;
            height: 116px;
            border-radius: 50%;
            background: rgba(92, 172, 238, 0.1);
            z-index: 1;
            animation: pulse 2s infinite;
        }
        
        .nickname {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 8px;
            color: var(--primary-dark);
            text-align: center;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .user-desc {
            opacity: 0.9;
            font-size: 14px;
            color: var(--text-medium);
            font-style: italic;
            text-align: center;
            max-width: 320px;
            margin-bottom: 16px;
            padding: 0 10px;
        }
        
        .time-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 10px;
            text-align: center;
        }
        
        .logo {
            font-size: 30px;
            margin-bottom: 4px;
            color: var(--primary-color);
            font-weight: 700;
            letter-spacing: 1px;
        }
        
        #date {
            font-size: 14px;
            color: var(--text-medium);
            font-weight: 500;
        }
        
        .weather {
            font-size: 13px;
            color: var(--text-medium);
            margin-top: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 4px;
        }
        
        /* 分隔装饰线 */
        .divider {
            height: 1px;
            background: linear-gradient(to right, transparent, rgba(100, 150, 255, 0.3), transparent);
            margin: 0 auto 20px;
            width: 80%;
            position: relative;
        }
        
        .divider-dots {
            position: absolute;
            top: -4px;
            left: 0;
            width: 100%;
            display: flex;
            justify-content: space-evenly;
            pointer-events: none;
        }
        
        .divider-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #FFD700;
            box-shadow: 0 0 5px rgba(255, 215, 0, 0.6);
        }
        
        /* 网站导航区 */
        .app-section {
            margin-bottom: 25px;
        }
        
        .app-section h2 {
            margin: 0 0 20px;
            font-weight: 600;
            text-align: center;
            color: var(--primary-dark);
            font-size: 20px;
            position: relative;
            padding-bottom: 8px;
        }
        
        .app-section h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: linear-gradient(to right, var(--primary-light), var(--primary-color));
            border-radius: 3px;
        }
        
        .app-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(110px, 1fr));
            gap: 16px;
            margin-bottom: 15px;
            opacity: 0;
            transform: translateY(10px);
            transition: opacity 0.6s 0.2s, transform 0.6s 0.2s;
        }
        
        /* 正方形卡片 */
        .app-item {
            aspect-ratio: 1/1;
            background: white;
            border-radius: 14px;
            padding: 12px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
            cursor: pointer;
            box-shadow: var(--box-shadow);
            border: 1px solid rgba(230, 240, 255, 0.9);
            position: relative;
            overflow: hidden;
        }
        
        .app-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(to bottom right, rgba(255,255,255,0.1), transparent);
            z-index: 0;
        }
        
        .app-item:hover {
            transform: translateY(-5px);
            box-shadow: var(--hover-shadow);
        }
        
        /* 增大图标尺寸 */
        .app-icon {
            width: 48px;
            height: 48px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.12);
            z-index: 1;
        }
        
        .app-icon svg {
            width: 28px;
            height: 28px;
        }
        
        .app-item p {
            font-size: 13px;
            color: var(--primary-dark);
            font-weight: 600;
            margin-top: 10px;
            transition: color 0.3s;
            text-align: center;
            line-height: 1.3;
            z-index: 1;
        }
        
        .app-item:hover p {
            color: var(--primary-color);
        }
        
        /* 页脚哦 */
        footer {
            text-align: center;
            padding: 16px 0 8px;
            color: var(--text-medium);
            font-size: 12px;
            margin-top: 15px;
            opacity: 0;
            transition: opacity 0.5s 0.4s;
            position: relative;
            z-index: 1;
            line-height: 1.6;
        }
        
        footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80%;
            height: 1px;
            background: linear-gradient(to right, transparent, rgba(120, 160, 240, 0.2), transparent);
        }
        
        .copyright {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
            margin-bottom: 5px;
        }
        
        .copyright svg {
            width: 12px;
            height: 12px;
        }
        
        .visitor-count {
            font-size: 11px;
            margin-top: 5px;
            display: inline-flex;
            align-items: center;
            gap: 4px;
        }
        
        .footer-links {
            display: flex;
            justify-content: center;
            gap: 18px;
            margin-top: 12px;
            font-size: 12px;
        }
        
        .footer-links a {
            color: var(--primary-color);
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer-links a:hover {
            color: var(--accent-color);
            text-decoration: underline;
        }
        
        /* 公告弹窗样式- */
        .announcement-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9998;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.4s, visibility 0.4s;
            backdrop-filter: blur(4px);
        }
        
        .announcement-modal.active {
            opacity: 1;
            visibility: visible;
        }
        
        .announcement-content {
            background: white;
            border-radius: 16px;
            box-shadow: 0 16px 32px rgba(70, 110, 180, 0.2);
            max-width: 460px;
            width: 90%;
            overflow: hidden;
            position: relative;
            transform: scale(0.9);
            transition: transform 0.4s ease, opacity 0.4s ease;
            opacity: 0;
        }
        
        .announcement-modal.active .announcement-content {
            transform: scale(1);
            opacity: 1;
        }
        
        .announcement-header {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 18px 22px;
            text-align: center;
            position: relative;
        }
        
        .announcement-header h3 {
            font-size: 18px;
            font-weight: 700;
            margin: 0;
        }
        
        .announcement-badge {
            position: absolute;
            top: 10px;
            right: 10px;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .announcement-badge:hover {
            background: rgba(255, 255, 255, 0.3);
        }
        
        .announcement-body {
            padding: 20px;
        }
        
        .announcement-body p {
            color: var(--text-medium);
            line-height: 1.6;
            margin-bottom: 14px;
            font-size: 14px;
            position: relative;
            padding-left: 20px;
        }
        
        .announcement-body p:before {
            content: '•';
            position: absolute;
            left: 0;
            top: 0;
            color: var(--primary-color);
            font-size: 20px;
        }
        
        .announcement-footer {
            padding: 16px 22px;
            background: #f8faff;
            text-align: center;
            border-top: 1px solid rgba(230, 240, 255, 0.9);
        }
        
        .close-btn {
            background: linear-gradient(135deg, var(--primary-light), var(--primary-color));
            color: white;
            border: none;
            padding: 10px 22px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            box-shadow: 0 4px 12px rgba(92, 172, 238, 0.25);
        }
        
        .close-btn:hover {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            box-shadow: 0 6px 16px rgba(92, 172, 238, 0.3);
            transform: translateY(-2px);
        }
        
        /* 小动画 */
        @keyframes float {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-6px); }
            100% { transform: translateY(0px); }
        }
        
        .floating {
            animation: float 4s ease-in-out infinite;
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(92, 172, 238, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(92, 172, 238, 0); }
            100% { box-shadow: 0 0 0 0 rgba(92, 172, 238, 0); }
        }
        
        /* 响应式设计 */
        @media (max-width: 768px) {
            .wave-bg {
                height: 50px;
            }
            
            .container {
                padding: 18px;
                margin-top: 10px;
            }
            
            .avatar-container {
                width: 90px;
                height: 90px;
            }
            
            .avatar-bg {
                width: 110px;
                height: 110px;
            }
            
            .nickname {
                font-size: 20px;
            }
            
            .logo {
                font-size: 28px;
            }
            
            .app-grid {
                grid-template-columns: repeat(auto-fit, minmax(90px, 1fr));
                gap: 12px;
            }
            
            .app-icon {
                width: 42px;
                height: 42px;
            }
            
            .app-icon svg {
                width: 24px;
                height: 24px;
            }
            
            .app-item p {
                font-size: 12px;
            }
            
            .footer-links {
                gap: 15px;
            }
        }
        
        @media (max-width: 480px) {
            body {
                padding: 12px;
            }
            
            .wave-bg {
                height: 40px;
            }
            
            .container {
                padding: 16px;
            }
            
            .avatar-container {
                width: 80px;
                height: 80px;
                margin-bottom: 14px;
            }
            
            .avatar-bg {
                width: 100px;
                height: 100px;
            }
            
            .nickname {
                font-size: 19px;
            }
            
            .user-desc {
                font-size: 13px;
            }
            
            .logo {
                font-size: 26px;
            }
            
            #date {
                font-size: 13px;
            }
            
            .app-grid {
                gap: 10px;
            }
            
            .app-item {
                padding: 10px;
                border-radius: 12px;
            }
            
            .app-icon {
                width: 40px;
                height: 40px;
            }
            
            .app-icon svg {
                width: 22px;
                height: 22px;
            }
            
            .app-item p {
                font-size: 11px;
                margin-top: 8px;
            }
            
            .footer-links {
                gap: 12px;
                font-size: 11px;
            }
        }
        
        @media (max-width: 350px) {
            .app-grid {
                grid-template-columns: repeat(auto-fit, minmax(80px, 1fr));
            }
            
            .avatar-container {
                width: 70px;
                height: 70px;
            }
            
            .avatar-bg {
                width: 90px;
                height: 90px;
            }
            
            .nickname {
                font-size: 18px;
            }
            
            .logo {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <!-- 波浪背景 -->
    <div class="wave-bg"></div>
    
    <!-- 加载动画 -->
    <div class="loader" id="loader">
        <div class="loader-content">
            <div class="loader-animation">
                <div class="loader-circle"></div>
                <div class="loader-circle"></div>
                <div class="loader-circle"></div>
            </div>
            <div class="loader-text">刀客源码导航 · 加载中</div>
        </div>
    </div>
    
    <div class="container" id="container">
        <!-- 背景装饰 -->
        <div class="bg-element bg-1 floating"></div>
        <div class="bg-element bg-2 floating"></div>
        <div class="bg-element bg-3 floating"></div>
        
        <!-- 顶部区域 -->
        <header>
            <div style="display: flex; flex-direction: column; align-items: center; width: 100%;">
                <div class="avatar-container">
                    <div class="avatar">
                        <img src="<?php echo $site_config['avatar_url']; ?>" alt="听风头像">
                    </div>
                    <div class="avatar-bg"></div>
                </div>
                <div class="user-info">
                    <h3 class="nickname"><?php echo $site_config['site_title']; ?></h3>
                    <p class="user-desc"><?php echo $site_config['site_desc']; ?></p>
                </div>
            </div>
            <div class="time-container">
                <h1 class="logo"><span id="time">00:00</span></h1>
                <p id="date">正在加载日期...</p>
                <div class="weather" id="weather">天气：晴 ☀️ 25℃</div>
            </div>
        </header>
        
        <!-- 分隔装饰线 -->
        <div class="divider">
            <div class="divider-dots">
                <div class="divider-dot"></div>
                <div class="divider-dot"></div>
                <div class="divider-dot"></div>
                <div class="divider-dot"></div>
            </div>
        </div>

        <!-- 网站导航 -->
        <div class="app-section">
            <h2>快捷导航</h2>
            <div class="app-grid">
                <?php foreach ($site_config['apps'] as $app): ?>
                <div class="app-item" data-app-name="<?php echo $app['name']; ?>">
                    <div class="app-icon" style="background:<?php echo $app['icon_bg']; ?>">
                        <?php echo $app['icon_svg']; ?>
                    </div>
                    <p><?php echo $app['name']; ?></p>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- 底部信息 -->
        <footer>
            <div class="copyright">
                <svg width="14" height="14" viewBox="0 0 24 24">
                    <path fill="#5a6b9c" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm-2-11.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5-.67 1.5-1.5 1.5-1.5-.67-1.5-1.5zm7 6c0 .28-.22.5-.5.5h-7c-.28 0-.5-.22-.5-.5v-1c0-.28.22-.5.5-.5h7c.28 0 .5.22.5.5v1z"/>
                </svg>
                <span><?php echo $site_config['copyright']; ?></span>
            </div>
            
            <div class="visitor-count">
                <svg width="12" height="12" viewBox="0 0 24 24">
                    <path fill="#5a6b9c" d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
                </svg>
                <span>今日访问量: <span id="visitorCount">19876</span> 次</span>
            </div>
            
            <div class="footer-links">
                <?php foreach ($site_config['footer_links'] as $link): ?>
                <a href="<?php echo $link['url']; ?>"><?php echo $link['text']; ?></a>
                <?php endforeach; ?>
            </div>
        </footer>
    </div>
    
    <!-- 公告弹窗 -->
    <div class="announcement-modal" id="announcementModal">
        <div class="announcement-content">
            <div class="announcement-header">
                <h3>重要公告</h3>
                <div class="announcement-badge" id="closeAnnouncement">×</div>
            </div>
            <div class="announcement-body">
                <p>导航页面已完成全面优化！</p>
                <p>应用图标已重新设计，视觉效果提升</p>
                <p>「免费去插播」服务持续优化中</p>
                <p>瓜子采集+解析稳定速度快推荐购买！</p>
            </div>
            <div class="announcement-footer">
                <button class="close-btn" id="closeAnnouncementBtn">我知道了</button>
            </div>
        </div>
    </div>

    <script>
        // 动态背景初始化（仅在非"none"时执行0.0）
        <?php if ($site_config['background_type'] !== 'none'): ?>
        document.addEventListener('DOMContentLoaded', function() {
            const bgType = '<?php echo $site_config["background_type"]; ?>';
            
            if (bgType === 'particles') initParticles();
            else if (bgType === 'waves') initWaves();
            else if (bgType === 'stars') initStars();
        });

        // 粒子效果
        function initParticles() {
            const canvas = document.createElement('canvas');
            canvas.style.position = 'fixed';
            canvas.style.top = '0';
            canvas.style.left = '0';
            canvas.style.zIndex = '-1';
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight;
            document.body.appendChild(canvas);

            const ctx = canvas.getContext('2d');
            const particles = [];
            const particleCount = window.innerWidth < 768 ? 30 : 50;

            for (let i = 0; i < particleCount; i++) {
                particles.push({
                    x: Math.random() * canvas.width,
                    y: Math.random() * canvas.height,
                    size: Math.random() * 3 + 1,
                    speedX: Math.random() * 1 - 0.5,
                    speedY: Math.random() * 1 - 0.5
                });
            }

            function animate() {
                ctx.clearRect(0, 0, canvas.width, canvas.height);
                ctx.fillStyle = 'rgba(255, 255, 255, 0.5)';

                particles.forEach(p => {
                    ctx.beginPath();
                    ctx.arc(p.x, p.y, p.size, 0, Math.PI * 2);
                    ctx.fill();

                    p.x += p.speedX;
                    p.y += p.speedY;

                    if (p.x < 0 || p.x > canvas.width) p.speedX *= -1;
                    if (p.y < 0 || p.y > canvas.height) p.speedY *= -1;
                });

                requestAnimationFrame(animate);
            }

            animate();

            window.addEventListener('resize', function() {
                canvas.width = window.innerWidth;
                canvas.height = window.innerHeight;
            });
        }

        // 波浪效果
        function initWaves() {
            const canvas = document.createElement('canvas');
            canvas.style.position = 'fixed';
            canvas.style.top = '0';
            canvas.style.left = '0';
            canvas.style.zIndex = '-1';
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight;
            document.body.appendChild(canvas);

            const ctx = canvas.getContext('2d');
            let time = 0;

            function animate() {
                ctx.clearRect(0, 0, canvas.width, canvas.height);
                ctx.fillStyle = 'rgba(255, 255, 255, 0.1)';
                ctx.beginPath();

                for (let x = 0; x < canvas.width; x++) {
                    const y = Math.sin(x * 0.01 + time) * 15 + canvas.height / 2;
                    if (x === 0) ctx.moveTo(x, y);
                    else ctx.lineTo(x, y);
                }

                ctx.lineTo(canvas.width, canvas.height);
                ctx.lineTo(0, canvas.height);
                ctx.closePath();
                ctx.fill();

                time += 0.05;
                requestAnimationFrame(animate);
            }

            animate();

            window.addEventListener('resize', function() {
                canvas.width = window.innerWidth;
                canvas.height = window.innerHeight;
            });
        }

        // 星空效果
        function initStars() {
            const canvas = document.createElement('canvas');
            canvas.style.position = 'fixed';
            canvas.style.top = '0';
            canvas.style.left = '0';
            canvas.style.zIndex = '-1';
            canvas.width = window.innerWidth;
            canvas.height = window.innerHeight;
            document.body.appendChild(canvas);

            const ctx = canvas.getContext('2d');
            const stars = [];
            const starCount = window.innerWidth < 768 ? 60 : 100;

            for (let i = 0; i < starCount; i++) {
                stars.push({
                    x: Math.random() * canvas.width,
                    y: Math.random() * canvas.height,
                    size: Math.random() * 2 + 0.5,
                    alpha: Math.random() * 0.8 + 0.2
                });
            }

            function animate() {
                ctx.clearRect(0, 0, canvas.width, canvas.height);

                stars.forEach(star => {
                    ctx.fillStyle = `rgba(255, 255, 255, ${star.alpha})`;
                    ctx.beginPath();
                    ctx.arc(star.x, star.y, star.size, 0, Math.PI * 2);
                    ctx.fill();

                    star.alpha += Math.random() * 0.1 - 0.05;
                    if (star.alpha < 0.2) star.alpha = 0.2;
                    if (star.alpha > 1) star.alpha = 1;
                });

                requestAnimationFrame(animate);
            }

            animate();

            window.addEventListener('resize', function() {
                canvas.width = window.innerWidth;
                canvas.height = window.innerHeight;
            });
        }
        <?php endif; ?>

        // 页面初始化
        document.addEventListener('DOMContentLoaded', () => {
            // 更新日期时间
            updateDateTime();
            
            // 显示主内容
            setTimeout(() => {
                const container = document.getElementById('container');
                container.style.opacity = '1';
                container.style.transform = 'none';
                
                // 显示网站网格
                document.querySelector('.app-grid').style.opacity = '1';
                document.querySelector('.app-grid').style.transform = 'none';
                
                // 显示页脚
                document.querySelector('footer').style.opacity = '1';
                
                // 隐藏加载器
                setTimeout(() => {
                    document.getElementById('loader').classList.add('hidden');
                    
                    // 延迟显示公告弹窗
                    setTimeout(showAnnouncement, 600);
                }, 400);
            }, 400);
            
            // 设置时间更新定时器
            setInterval(updateDateTime, 1000);
            
            // 添加应用点击事件
            setupAppLinks();
            
            // 公告弹窗事件
            const modal = document.getElementById('announcementModal');
            const closeButtons = [
                document.getElementById('closeAnnouncement'),
                document.getElementById('closeAnnouncementBtn')
            ];
            
            closeButtons.forEach(button => {
                button.addEventListener('click', () => {
                    hideAnnouncement();
                    localStorage.setItem('announcementSeenDate', new Date().toISOString().split('T')[0]);
                });
            });
            
            // 点击弹窗背景关闭弹窗
            modal.addEventListener('click', (e) => {
                if (e.target === modal) {
                    hideAnnouncement();
                    localStorage.setItem('announcementSeenDate', new Date().toISOString().split('T')[0]);
                }
            });
            
            // 模拟访问量
            updateVisitorCount();
            
            // 根据设备类型调整天气显示
            adjustWeatherDisplay();
        });
        
        // 更新时间函数
        function updateDateTime() {
            const now = new Date();
            
            // 格式化时间
            const timeStr = now.toLocaleTimeString('zh-CN', {
                hour: '2-digit',
                minute: '2-digit'
            });
            
            // 格式化日期
            const dateOptions = {
                year: 'numeric',
                month: 'long',
                day: 'numeric',
                weekday: 'long'
            };
            const dateStr = now.toLocaleDateString('zh-CN', dateOptions);
            
            // 更新DOM
            document.getElementById('time').textContent = timeStr;
            document.getElementById('date').textContent = dateStr;
        }
        
        // 应用链接配置
        const appLinks = {
            <?php foreach ($site_config['apps'] as $app): ?>
            "<?php echo $app['name']; ?>": "<?php echo $app['url']; ?>",
            <?php endforeach; ?>
        };
        
        // 应用点击事件设置
        function setupAppLinks() {
            document.querySelectorAll('.app-item').forEach(item => {
                item.addEventListener('click', function() {
                    this.style.transform = 'scale(0.95)';
                    setTimeout(() => {
                        this.style.transform = '';
                    }, 200);
                    
                    const appName = this.getAttribute('data-app-name');
                    const link = appLinks[appName];
                    
                    if (link) {
                        setTimeout(() => {
                            window.open(link, '_blank');
                        }, 300);
                    }
                });
            });
        }
        
        // 显示公告弹窗
        function showAnnouncement() {
            const lastSeenDate = localStorage.getItem('announcementSeenDate');
            const today = new Date().toISOString().split('T')[0];
            
            if (lastSeenDate !== today) {
                document.getElementById('announcementModal').classList.add('active');
            }
        }
        
        // 隐藏公告弹窗
        function hideAnnouncement() {
            document.getElementById('announcementModal').classList.remove('active');
        }
        
        // 更新访问量计数
        function updateVisitorCount() {
            const countEl = document.getElementById('visitorCount');
            let count = Math.floor(Math.random() * 10000) + 15000;
            countEl.textContent = count.toLocaleString();
            
            setInterval(() => {
                count += Math.floor(Math.random() * 5) + 1;
                countEl.textContent = count.toLocaleString();
            }, 15000);
        }
        
        // 根据设备类型调整天气显示
        function adjustWeatherDisplay() {
            const weatherEl = document.getElementById('weather');
            if (window.innerWidth < 768) {
                weatherEl.textContent = '☀️ 25℃';
            } else {
                weatherEl.textContent = '天气：晴 ☀️ 25℃';
            }
        }
        
        // 监听窗口大小变化
        window.addEventListener('resize', adjustWeatherDisplay);
    </script>
</body>
</html>